/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.observers;

import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import shadow.io.reactivex.rxjava3.core.CompletableObserver;
import shadow.io.reactivex.rxjava3.core.MaybeObserver;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Action;
import shadow.io.reactivex.rxjava3.functions.Consumer;
import shadow.io.reactivex.rxjava3.internal.util.BlockingHelper;
import shadow.io.reactivex.rxjava3.internal.util.ExceptionHelper;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class BlockingMultiObserver<T>
extends CountDownLatch
implements SingleObserver<T>,
CompletableObserver,
MaybeObserver<T> {
    T value;
    Throwable error;
    Disposable upstream;
    volatile boolean cancelled;

    public BlockingMultiObserver() {
        super(1);
    }

    void dispose() {
        this.cancelled = true;
        Disposable d = this.upstream;
        if (d != null) {
            d.dispose();
        }
    }

    @Override
    public void onSubscribe(Disposable d) {
        this.upstream = d;
        if (this.cancelled) {
            d.dispose();
        }
    }

    @Override
    public void onSuccess(T value) {
        this.value = value;
        this.countDown();
    }

    @Override
    public void onError(Throwable e) {
        this.error = e;
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.countDown();
    }

    public T blockingGet() {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return this.value;
    }

    public T blockingGet(T defaultValue) {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        T v = this.value;
        return v != null ? v : defaultValue;
    }

    public boolean blockingAwait(long timeout, TimeUnit unit) {
        Throwable ex;
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                if (!this.await(timeout, unit)) {
                    this.dispose();
                    return false;
                }
            }
            catch (InterruptedException ex2) {
                this.dispose();
                throw ExceptionHelper.wrapOrThrow(ex2);
            }
        }
        if ((ex = this.error) != null) {
            throw ExceptionHelper.wrapOrThrow(ex);
        }
        return true;
    }

    public void blockingConsume(Consumer<? super T> onSuccess, Consumer<? super Throwable> onError, Action onComplete) {
        try {
            Throwable ex;
            if (this.getCount() != 0L) {
                try {
                    BlockingHelper.verifyNonBlocking();
                    this.await();
                }
                catch (InterruptedException ex2) {
                    this.dispose();
                    onError.accept(ex2);
                    return;
                }
            }
            if ((ex = this.error) != null) {
                onError.accept(ex);
                return;
            }
            T v = this.value;
            if (v != null) {
                onSuccess.accept(v);
            } else {
                onComplete.run();
            }
        }
        catch (Throwable t) {
            Exceptions.throwIfFatal(t);
            RxJavaPlugins.onError(t);
        }
    }
}

