/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.observers;

import java.util.concurrent.CountDownLatch;
import shadow.io.reactivex.rxjava3.annotations.NonNull;
import shadow.io.reactivex.rxjava3.core.CompletableObserver;
import shadow.io.reactivex.rxjava3.core.MaybeObserver;
import shadow.io.reactivex.rxjava3.core.SingleObserver;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.internal.disposables.SequentialDisposable;
import shadow.io.reactivex.rxjava3.internal.util.BlockingHelper;

public final class BlockingDisposableMultiObserver<T>
extends CountDownLatch
implements MaybeObserver<T>,
SingleObserver<T>,
CompletableObserver,
Disposable {
    T value;
    Throwable error;
    final SequentialDisposable upstream = new SequentialDisposable();

    public BlockingDisposableMultiObserver() {
        super(1);
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
        this.countDown();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public void onSubscribe(@NonNull Disposable d) {
        DisposableHelper.setOnce(this.upstream, d);
    }

    @Override
    public void onSuccess(@NonNull T t) {
        this.value = t;
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    @Override
    public void onError(@NonNull Throwable e) {
        this.error = e;
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    @Override
    public void onComplete() {
        this.upstream.lazySet(Disposable.disposed());
        this.countDown();
    }

    public void blockingConsume(CompletableObserver observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                observer.onError(ex);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex = this.error;
        if (ex != null) {
            observer.onError(ex);
        } else {
            observer.onComplete();
        }
    }

    public void blockingConsume(SingleObserver<? super T> observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                observer.onError(ex);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex = this.error;
        if (ex != null) {
            observer.onError(ex);
        } else {
            observer.onSuccess(this.value);
        }
    }

    public void blockingConsume(MaybeObserver<? super T> observer) {
        if (this.getCount() != 0L) {
            try {
                BlockingHelper.verifyNonBlocking();
                this.await();
            }
            catch (InterruptedException ex) {
                this.dispose();
                observer.onError(ex);
                return;
            }
        }
        if (this.isDisposed()) {
            return;
        }
        Throwable ex = this.error;
        if (ex != null) {
            observer.onError(ex);
        } else {
            T v = this.value;
            if (v == null) {
                observer.onComplete();
            } else {
                observer.onSuccess(v);
            }
        }
    }
}

