/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.observers;

import shadow.io.reactivex.rxjava3.core.Observer;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.internal.disposables.DisposableHelper;
import shadow.io.reactivex.rxjava3.operators.QueueDisposable;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public abstract class BasicFuseableObserver<T, R>
implements Observer<T>,
QueueDisposable<R> {
    protected final Observer<? super R> downstream;
    protected Disposable upstream;
    protected QueueDisposable<T> qd;
    protected boolean done;
    protected int sourceMode;

    public BasicFuseableObserver(Observer<? super R> downstream) {
        this.downstream = downstream;
    }

    @Override
    public final void onSubscribe(Disposable d) {
        if (DisposableHelper.validate(this.upstream, d)) {
            this.upstream = d;
            if (d instanceof QueueDisposable) {
                this.qd = (QueueDisposable)d;
            }
            if (this.beforeDownstream()) {
                this.downstream.onSubscribe(this);
                this.afterDownstream();
            }
        }
    }

    protected boolean beforeDownstream() {
        return true;
    }

    protected void afterDownstream() {
    }

    @Override
    public void onError(Throwable t) {
        if (this.done) {
            RxJavaPlugins.onError(t);
            return;
        }
        this.done = true;
        this.downstream.onError(t);
    }

    protected final void fail(Throwable t) {
        Exceptions.throwIfFatal(t);
        this.upstream.dispose();
        this.onError(t);
    }

    @Override
    public void onComplete() {
        if (this.done) {
            return;
        }
        this.done = true;
        this.downstream.onComplete();
    }

    protected final int transitiveBoundaryFusion(int mode) {
        QueueDisposable<T> qd = this.qd;
        if (qd != null && (mode & 4) == 0) {
            int m = qd.requestFusion(mode);
            if (m != 0) {
                this.sourceMode = m;
            }
            return m;
        }
        return 0;
    }

    @Override
    public void dispose() {
        this.upstream.dispose();
    }

    @Override
    public boolean isDisposed() {
        return this.upstream.isDisposed();
    }

    @Override
    public boolean isEmpty() {
        return this.qd.isEmpty();
    }

    @Override
    public void clear() {
        this.qd.clear();
    }

    @Override
    public final boolean offer(R e) {
        throw new UnsupportedOperationException("Should not be called!");
    }

    @Override
    public final boolean offer(R v1, R v2) {
        throw new UnsupportedOperationException("Should not be called!");
    }
}

