/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.reactivex.rxjava3.internal.disposables;

import java.util.concurrent.atomic.AtomicReference;
import shadow.io.reactivex.rxjava3.disposables.Disposable;
import shadow.io.reactivex.rxjava3.exceptions.Exceptions;
import shadow.io.reactivex.rxjava3.functions.Cancellable;
import shadow.io.reactivex.rxjava3.plugins.RxJavaPlugins;

public final class CancellableDisposable
extends AtomicReference<Cancellable>
implements Disposable {
    private static final long serialVersionUID = 5718521705281392066L;

    public CancellableDisposable(Cancellable cancellable) {
        super(cancellable);
    }

    @Override
    public boolean isDisposed() {
        return this.get() == null;
    }

    @Override
    public void dispose() {
        Cancellable c;
        if (this.get() != null && (c = (Cancellable)this.getAndSet(null)) != null) {
            try {
                c.cancel();
            }
            catch (Throwable ex) {
                Exceptions.throwIfFatal(ex);
                RxJavaPlugins.onError(ex);
            }
        }
    }
}

