/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.validation.selfvalidating;

import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.classmate.AnnotationConfiguration;
import shadow.com.fasterxml.classmate.AnnotationInclusion;
import shadow.com.fasterxml.classmate.MemberResolver;
import shadow.com.fasterxml.classmate.ResolvedTypeWithMembers;
import shadow.com.fasterxml.classmate.TypeResolver;
import shadow.com.fasterxml.classmate.members.ResolvedMethod;
import shadow.io.dropwizard.validation.selfvalidating.SelfValidating;
import shadow.io.dropwizard.validation.selfvalidating.SelfValidation;
import shadow.io.dropwizard.validation.selfvalidating.ValidationCaller;
import shadow.io.dropwizard.validation.selfvalidating.ViolationCollector;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;

public class SelfValidatingValidator
implements ConstraintValidator<SelfValidating, Object> {
    private static final Logger log = LoggerFactory.getLogger(SelfValidatingValidator.class);
    private final ConcurrentMap<Class<?>, List<ValidationCaller>> methodMap = new ConcurrentHashMap();
    private final AnnotationConfiguration annotationConfiguration = new AnnotationConfiguration.StdConfiguration(AnnotationInclusion.INCLUDE_AND_INHERIT_IF_INHERITED);
    private final TypeResolver typeResolver = new TypeResolver();
    private final MemberResolver memberResolver = new MemberResolver(this.typeResolver);
    private boolean escapeExpressions = true;

    @Override
    public void initialize(SelfValidating constraintAnnotation) {
        this.escapeExpressions = constraintAnnotation.escapeExpressions();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        ViolationCollector collector = new ViolationCollector(context, this.escapeExpressions);
        context.disableDefaultConstraintViolation();
        for (ValidationCaller caller : this.methodMap.computeIfAbsent(value.getClass(), this::findMethods)) {
            caller.setValidationObject(value);
            caller.call(collector);
        }
        return !collector.hasViolationOccurred();
    }

    private <T> List<ValidationCaller> findMethods(Class<T> annotated) {
        ResolvedTypeWithMembers annotatedType = this.memberResolver.resolve(this.typeResolver.resolve(annotated, new Type[0]), this.annotationConfiguration, null);
        List<ValidationCaller> callers = Arrays.stream(annotatedType.getMemberMethods()).filter(this::isValidationMethod).filter(this::isMethodCorrect).map(m -> new ProxyValidationCaller(annotated, (ResolvedMethod)m)).collect(Collectors.toList());
        if (callers.isEmpty()) {
            log.warn("The class {} is annotated with @SelfValidating but contains no valid methods that are annotated with @SelfValidation", (Object)annotated);
        }
        return callers;
    }

    private boolean isValidationMethod(ResolvedMethod m) {
        return m.get(SelfValidation.class) != null;
    }

    boolean isMethodCorrect(ResolvedMethod m) {
        if (m.getReturnType() != null) {
            log.error("The method {} is annotated with @SelfValidation but does not return void. It is ignored", m.getRawMember());
            return false;
        }
        if (m.getArgumentCount() != 1 || !m.getArgumentType(0).getErasedType().equals(ViolationCollector.class)) {
            log.error("The method {} is annotated with @SelfValidation but does not have a single parameter of type {}", m.getRawMember(), (Object)ViolationCollector.class);
            return false;
        }
        if (!m.isPublic()) {
            log.error("The method {} is annotated with @SelfValidation but is not public", m.getRawMember());
            return false;
        }
        return true;
    }

    static final class ProxyValidationCaller<T>
    extends ValidationCaller<T> {
        private final Class<T> cls;
        private final ResolvedMethod resolvedMethod;

        ProxyValidationCaller(Class<T> cls, ResolvedMethod resolvedMethod) {
            this.cls = cls;
            this.resolvedMethod = resolvedMethod;
        }

        @Override
        public void call(ViolationCollector vc) {
            Method method = (Method)this.resolvedMethod.getRawMember();
            T obj = this.cls.cast(this.getValidationObject());
            try {
                method.invoke(obj, vc);
            }
            catch (ReflectiveOperationException e) {
                throw new IllegalStateException("Couldn't call " + this.resolvedMethod + " on " + this.getValidationObject(), e);
            }
        }
    }
}

