/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.validation;

import shadow.io.dropwizard.validation.OneOf;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;

public class OneOfValidator
implements ConstraintValidator<OneOf, Object> {
    private String[] values = new String[0];
    private boolean caseInsensitive;
    private boolean ignoreWhitespace;

    @Override
    public void initialize(OneOf constraintAnnotation) {
        this.values = constraintAnnotation.value();
        this.caseInsensitive = constraintAnnotation.ignoreCase();
        this.ignoreWhitespace = constraintAnnotation.ignoreWhitespace();
    }

    @Override
    public boolean isValid(Object value, ConstraintValidatorContext context) {
        String v;
        if (value == null) {
            return true;
        }
        String string = v = this.ignoreWhitespace ? value.toString().trim() : value.toString();
        if (this.caseInsensitive) {
            for (String s : this.values) {
                if (!s.equalsIgnoreCase(v)) continue;
                return true;
            }
        } else {
            for (String s : this.values) {
                if (!s.equals(v)) continue;
                return true;
            }
        }
        return false;
    }
}

