/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.validation;

import shadow.io.dropwizard.util.DataSize;
import shadow.io.dropwizard.util.DataSizeUnit;
import shadow.io.dropwizard.validation.MinDataSize;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;

public class MinDataSizeValidator
implements ConstraintValidator<MinDataSize, DataSize> {
    private long minQty = 0L;
    private DataSizeUnit minUnit = DataSizeUnit.BYTES;

    @Override
    public void initialize(MinDataSize constraintAnnotation) {
        this.minQty = constraintAnnotation.value();
        this.minUnit = constraintAnnotation.unit();
    }

    @Override
    public boolean isValid(DataSize value, ConstraintValidatorContext context) {
        return value == null || value.toBytes() >= this.minUnit.toBytes(this.minQty);
    }
}

