/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.validation;

import java.util.concurrent.TimeUnit;
import shadow.io.dropwizard.util.Duration;
import shadow.io.dropwizard.validation.MaxDuration;
import shadow.javax.validation.ConstraintValidator;
import shadow.javax.validation.ConstraintValidatorContext;

public class MaxDurationValidator
implements ConstraintValidator<MaxDuration, Duration> {
    private long maxQty = 0L;
    private TimeUnit maxUnit = TimeUnit.MILLISECONDS;
    private boolean inclusive = true;

    @Override
    public void initialize(MaxDuration constraintAnnotation) {
        this.maxQty = constraintAnnotation.value();
        this.maxUnit = constraintAnnotation.unit();
        this.inclusive = constraintAnnotation.inclusive();
    }

    @Override
    public boolean isValid(Duration value, ConstraintValidatorContext context) {
        if (value == null) {
            return true;
        }
        long valueNanos = value.toNanoseconds();
        long annotationNanos = this.maxUnit.toNanos(this.maxQty);
        if (this.inclusive) {
            return valueNanos <= annotationNanos;
        }
        return valueNanos < annotationNanos;
    }
}

