/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.validation;

import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.TreeSet;
import shadow.io.dropwizard.validation.ValidationMethod;
import shadow.javax.validation.ConstraintViolation;

public class ConstraintViolations {
    private ConstraintViolations() {
    }

    public static <T> String format(ConstraintViolation<T> v) {
        if (v.getConstraintDescriptor().getAnnotation() instanceof ValidationMethod) {
            return v.getMessage();
        }
        return String.format("%s %s", v.getPropertyPath(), v.getMessage());
    }

    public static <T> Collection<String> format(Set<ConstraintViolation<T>> violations) {
        TreeSet<String> errors = new TreeSet<String>();
        for (ConstraintViolation<T> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return errors;
    }

    public static Collection<String> formatUntyped(Set<ConstraintViolation<?>> violations) {
        TreeSet<String> errors = new TreeSet<String>();
        for (ConstraintViolation<?> v : violations) {
            errors.add(ConstraintViolations.format(v));
        }
        return errors;
    }

    public static <T> Set<ConstraintViolation<?>> copyOf(Set<ConstraintViolation<T>> violations) {
        return new HashSet(violations);
    }
}

