/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.util;

import java.io.Serializable;
import java.util.Collections;
import java.util.Locale;
import java.util.Objects;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.com.fasterxml.jackson.annotation.JsonCreator;
import shadow.com.fasterxml.jackson.annotation.JsonValue;
import shadow.io.dropwizard.util.DataSize;
import shadow.io.dropwizard.util.SizeUnit;

@Deprecated
public class Size
implements Comparable<Size>,
Serializable {
    private static final long serialVersionUID = 6790991929249604526L;
    private static final Pattern SIZE_PATTERN = Pattern.compile("(\\d+)\\s*(\\S+)");
    private static final SortedMap<String, SizeUnit> SUFFIXES;
    private final long count;
    private final SizeUnit unit;

    public static Size bytes(long count) {
        return new Size(count, SizeUnit.BYTES);
    }

    public static Size kilobytes(long count) {
        return new Size(count, SizeUnit.KILOBYTES);
    }

    public static Size megabytes(long count) {
        return new Size(count, SizeUnit.MEGABYTES);
    }

    public static Size gigabytes(long count) {
        return new Size(count, SizeUnit.GIGABYTES);
    }

    public static Size terabytes(long count) {
        return new Size(count, SizeUnit.TERABYTES);
    }

    @JsonCreator
    public static Size parse(String size) {
        Matcher matcher = SIZE_PATTERN.matcher(size);
        if (!matcher.matches()) {
            throw new IllegalArgumentException("Invalid size: " + size);
        }
        long count = Long.parseLong(matcher.group(1));
        SizeUnit unit = (SizeUnit)((Object)SUFFIXES.get(matcher.group(2)));
        if (unit == null) {
            throw new IllegalArgumentException("Invalid size: " + size + ". Wrong size unit");
        }
        return new Size(count, unit);
    }

    private Size(long count, SizeUnit unit) {
        this.count = count;
        this.unit = Objects.requireNonNull(unit);
    }

    public long getQuantity() {
        return this.count;
    }

    public SizeUnit getUnit() {
        return this.unit;
    }

    public long toBytes() {
        return SizeUnit.BYTES.convert(this.count, this.unit);
    }

    public long toKilobytes() {
        return SizeUnit.KILOBYTES.convert(this.count, this.unit);
    }

    public long toMegabytes() {
        return SizeUnit.MEGABYTES.convert(this.count, this.unit);
    }

    public long toGigabytes() {
        return SizeUnit.GIGABYTES.convert(this.count, this.unit);
    }

    public long toTerabytes() {
        return SizeUnit.TERABYTES.convert(this.count, this.unit);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Size size = (Size)obj;
        return this.compareTo(size) == 0;
    }

    public int hashCode() {
        return 31 * (int)(this.count ^ this.count >>> 32) + this.unit.hashCode();
    }

    @JsonValue
    public String toString() {
        String units = this.unit.toString().toLowerCase(Locale.ENGLISH);
        if (this.count == 1L) {
            units = units.substring(0, units.length() - 1);
        }
        return Long.toString(this.count) + ' ' + units;
    }

    @Override
    public int compareTo(Size other) {
        if (this.unit == other.unit) {
            return Long.compare(this.count, other.count);
        }
        return Long.compare(this.toBytes(), other.toBytes());
    }

    public DataSize toDataSize() {
        switch (this.unit) {
            case BYTES: {
                return DataSize.bytes(this.count);
            }
            case KILOBYTES: {
                return DataSize.kibibytes(this.count);
            }
            case MEGABYTES: {
                return DataSize.mebibytes(this.count);
            }
            case GIGABYTES: {
                return DataSize.gibibytes(this.count);
            }
            case TERABYTES: {
                return DataSize.tebibytes(this.count);
            }
        }
        throw new IllegalArgumentException("Unknown unit: " + (Object)((Object)this.getUnit()));
    }

    public static Size fromDataSize(DataSize dataSize) {
        switch (dataSize.getUnit()) {
            case BYTES: {
                return Size.bytes(dataSize.getQuantity());
            }
            case KIBIBYTES: {
                return Size.kilobytes(dataSize.getQuantity());
            }
            case KILOBYTES: {
                return Size.bytes(dataSize.toBytes());
            }
            case MEBIBYTES: {
                return Size.megabytes(dataSize.getQuantity());
            }
            case MEGABYTES: {
                return Size.bytes(dataSize.toBytes());
            }
            case GIBIBYTES: {
                return Size.gigabytes(dataSize.getQuantity());
            }
            case GIGABYTES: {
                return Size.bytes(dataSize.toBytes());
            }
            case TEBIBYTES: {
                return Size.terabytes(dataSize.getQuantity());
            }
            case TERABYTES: {
                return Size.bytes(dataSize.toBytes());
            }
            case PEBIBYTES: {
                return Size.terabytes(dataSize.toTebibytes() * 1024L);
            }
            case PETABYTES: {
                return Size.bytes(dataSize.toBytes());
            }
        }
        throw new IllegalArgumentException("Unknown unit: " + (Object)((Object)dataSize.getUnit()));
    }

    static {
        TreeMap<String, SizeUnit> suffixes = new TreeMap<String, SizeUnit>(String.CASE_INSENSITIVE_ORDER);
        suffixes.put("B", SizeUnit.BYTES);
        suffixes.put("byte", SizeUnit.BYTES);
        suffixes.put("bytes", SizeUnit.BYTES);
        suffixes.put("K", SizeUnit.KILOBYTES);
        suffixes.put("KB", SizeUnit.KILOBYTES);
        suffixes.put("KiB", SizeUnit.KILOBYTES);
        suffixes.put("kilobyte", SizeUnit.KILOBYTES);
        suffixes.put("kilobytes", SizeUnit.KILOBYTES);
        suffixes.put("M", SizeUnit.MEGABYTES);
        suffixes.put("MB", SizeUnit.MEGABYTES);
        suffixes.put("MiB", SizeUnit.MEGABYTES);
        suffixes.put("megabyte", SizeUnit.MEGABYTES);
        suffixes.put("megabytes", SizeUnit.MEGABYTES);
        suffixes.put("G", SizeUnit.GIGABYTES);
        suffixes.put("GB", SizeUnit.GIGABYTES);
        suffixes.put("GiB", SizeUnit.GIGABYTES);
        suffixes.put("gigabyte", SizeUnit.GIGABYTES);
        suffixes.put("gigabytes", SizeUnit.GIGABYTES);
        suffixes.put("T", SizeUnit.TERABYTES);
        suffixes.put("TB", SizeUnit.TERABYTES);
        suffixes.put("TiB", SizeUnit.TERABYTES);
        suffixes.put("terabyte", SizeUnit.TERABYTES);
        suffixes.put("terabytes", SizeUnit.TERABYTES);
        SUFFIXES = Collections.unmodifiableSortedMap(suffixes);
    }
}

