/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.setup;

import java.util.Objects;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadPoolExecutor;
import shadow.com.codahale.metrics.MetricRegistry;
import shadow.com.codahale.metrics.SharedMetricRegistries;
import shadow.com.codahale.metrics.health.HealthCheckRegistry;
import shadow.com.codahale.metrics.health.SharedHealthCheckRegistries;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.io.dropwizard.Configuration;
import shadow.io.dropwizard.jackson.Jackson;
import shadow.io.dropwizard.jersey.DropwizardResourceConfig;
import shadow.io.dropwizard.jersey.setup.JerseyContainerHolder;
import shadow.io.dropwizard.jersey.setup.JerseyEnvironment;
import shadow.io.dropwizard.jersey.setup.JerseyServletContainer;
import shadow.io.dropwizard.jersey.validation.Validators;
import shadow.io.dropwizard.jetty.MutableServletContextHandler;
import shadow.io.dropwizard.jetty.setup.ServletEnvironment;
import shadow.io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import shadow.io.dropwizard.setup.AdminEnvironment;
import shadow.io.dropwizard.setup.AdminFactory;
import shadow.io.dropwizard.setup.HealthCheckConfiguration;
import shadow.io.dropwizard.validation.InjectValidatorFeature;
import shadow.javax.annotation.Nullable;
import shadow.javax.servlet.Servlet;
import shadow.javax.validation.Validator;
import shadow.javax.validation.ValidatorFactory;

public class Environment {
    private final String name;
    private final MetricRegistry metricRegistry;
    private final HealthCheckRegistry healthCheckRegistry;
    private final ObjectMapper objectMapper;
    private Validator validator;
    private final JerseyContainerHolder jerseyServletContainer;
    private final JerseyEnvironment jerseyEnvironment;
    private final MutableServletContextHandler servletContext;
    private final ServletEnvironment servletEnvironment;
    private final LifecycleEnvironment lifecycleEnvironment;
    private final MutableServletContextHandler adminContext;
    private final AdminEnvironment adminEnvironment;
    private final ExecutorService healthCheckExecutorService;

    public Environment(String name, ObjectMapper objectMapper, ValidatorFactory validatorFactory, MetricRegistry metricRegistry, @Nullable ClassLoader classLoader, HealthCheckRegistry healthCheckRegistry, Configuration configuration) {
        this.name = name;
        this.objectMapper = objectMapper;
        this.metricRegistry = metricRegistry;
        this.healthCheckRegistry = healthCheckRegistry;
        this.validator = validatorFactory.getValidator();
        this.servletContext = new MutableServletContextHandler();
        this.servletContext.setClassLoader(classLoader);
        this.servletEnvironment = new ServletEnvironment(this.servletContext);
        this.adminContext = new MutableServletContextHandler();
        this.adminContext.setClassLoader(classLoader);
        AdminFactory adminFactory = configuration.getAdminFactory();
        this.adminEnvironment = new AdminEnvironment(this.adminContext, healthCheckRegistry, metricRegistry, adminFactory);
        this.lifecycleEnvironment = new LifecycleEnvironment(metricRegistry);
        DropwizardResourceConfig jerseyConfig = new DropwizardResourceConfig(metricRegistry);
        jerseyConfig.setContextPath(this.servletContext.getContextPath());
        this.jerseyServletContainer = new JerseyContainerHolder(new JerseyServletContainer(jerseyConfig));
        JerseyEnvironment jerseyEnvironment = new JerseyEnvironment(this.jerseyServletContainer, jerseyConfig);
        jerseyEnvironment.register(new InjectValidatorFeature(validatorFactory));
        this.jerseyEnvironment = jerseyEnvironment;
        HealthCheckConfiguration healthCheckConfig = adminFactory.getHealthChecks();
        this.healthCheckExecutorService = this.lifecycle().executorService("TimeBoundHealthCheck-pool-%d").workQueue(new ArrayBlockingQueue<Runnable>(healthCheckConfig.getWorkQueueSize())).minThreads(healthCheckConfig.getMinThreads()).maxThreads(healthCheckConfig.getMaxThreads()).threadFactory(r -> {
            Thread thread = Executors.defaultThreadFactory().newThread(r);
            thread.setDaemon(true);
            return thread;
        }).rejectedExecutionHandler(new ThreadPoolExecutor.CallerRunsPolicy()).build();
        try {
            SharedMetricRegistries.setDefault("default", metricRegistry);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        try {
            SharedHealthCheckRegistries.setDefault("default", healthCheckRegistry);
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public Environment(String name) {
        this(name, Jackson.newObjectMapper(), Validators.newValidatorFactory(), new MetricRegistry(), ClassLoader.getSystemClassLoader(), new HealthCheckRegistry(), new Configuration());
    }

    public JerseyEnvironment jersey() {
        return this.jerseyEnvironment;
    }

    public ExecutorService getHealthCheckExecutorService() {
        return this.healthCheckExecutorService;
    }

    public AdminEnvironment admin() {
        return this.adminEnvironment;
    }

    public LifecycleEnvironment lifecycle() {
        return this.lifecycleEnvironment;
    }

    public ServletEnvironment servlets() {
        return this.servletEnvironment;
    }

    public ObjectMapper getObjectMapper() {
        return this.objectMapper;
    }

    public String getName() {
        return this.name;
    }

    public Validator getValidator() {
        return this.validator;
    }

    public void setValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    public MetricRegistry metrics() {
        return this.metricRegistry;
    }

    public HealthCheckRegistry healthChecks() {
        return this.healthCheckRegistry;
    }

    public MutableServletContextHandler getApplicationContext() {
        return this.servletContext;
    }

    @Nullable
    public Servlet getJerseyServletContainer() {
        return this.jerseyServletContainer.getContainer();
    }

    public MutableServletContextHandler getAdminContext() {
        return this.adminContext;
    }
}

