/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.setup;

import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.codahale.metrics.MetricRegistry;
import shadow.com.codahale.metrics.health.HealthCheckRegistry;
import shadow.com.codahale.metrics.health.jvm.ThreadDeadlockHealthCheck;
import shadow.io.dropwizard.jetty.MutableServletContextHandler;
import shadow.io.dropwizard.jetty.setup.ServletEnvironment;
import shadow.io.dropwizard.servlets.tasks.GarbageCollectionTask;
import shadow.io.dropwizard.servlets.tasks.LogConfigurationTask;
import shadow.io.dropwizard.servlets.tasks.Task;
import shadow.io.dropwizard.servlets.tasks.TaskServlet;
import shadow.io.dropwizard.setup.AdminFactory;
import shadow.org.eclipse.jetty.util.component.AbstractLifeCycle;
import shadow.org.eclipse.jetty.util.component.LifeCycle;

public class AdminEnvironment
extends ServletEnvironment {
    private static final Logger LOGGER = LoggerFactory.getLogger(AdminEnvironment.class);
    private final HealthCheckRegistry healthChecks;
    private final TaskServlet tasks;

    public AdminEnvironment(MutableServletContextHandler handler, HealthCheckRegistry healthChecks, MetricRegistry metricRegistry, AdminFactory adminFactory) {
        super(handler);
        this.healthChecks = healthChecks;
        this.healthChecks.register("deadlocks", new ThreadDeadlockHealthCheck());
        this.tasks = new TaskServlet(metricRegistry, adminFactory.getTasks());
        this.tasks.add(new GarbageCollectionTask());
        this.tasks.add(new LogConfigurationTask());
        this.addServlet("tasks", this.tasks).addMapping("/tasks/*");
        handler.addLifeCycleListener(new AbstractLifeCycle.AbstractLifeCycleListener(){

            @Override
            public void lifeCycleStarting(LifeCycle event) {
                AdminEnvironment.this.logTasks();
                AdminEnvironment.this.logHealthChecks();
            }
        });
    }

    public void addTask(Task task) {
        this.tasks.add(Objects.requireNonNull(task));
    }

    private void logTasks() {
        StringBuilder stringBuilder = new StringBuilder(1024).append(String.format("%n%n", new Object[0]));
        for (Task task : this.tasks.getTasks()) {
            String taskClassName = AdminEnvironment.firstNonNull(task.getClass().getCanonicalName(), task.getClass().getName());
            stringBuilder.append(String.format("    %-7s /tasks/%s (%s)%n", "POST", task.getName(), taskClassName));
        }
        LOGGER.info("tasks = {}", (Object)stringBuilder);
    }

    private static <T> T firstNonNull(T first, T second) {
        return first == null ? second : first;
    }

    private void logHealthChecks() {
        if (this.healthChecks.getNames().size() <= 1) {
            LOGGER.warn(String.format("%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!%n!    THIS APPLICATION HAS NO HEALTHCHECKS. THIS MEANS YOU WILL NEVER KNOW      !%n!     IF IT DIES IN PRODUCTION, WHICH MEANS YOU WILL NEVER KNOW IF YOU'RE      !%n!    LETTING YOUR USERS DOWN. YOU SHOULD ADD A HEALTHCHECK FOR EACH OF YOUR    !%n!         APPLICATION'S DEPENDENCIES WHICH FULLY (BUT LIGHTLY) TESTS IT.       !%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!%n!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!!", new Object[0]));
        }
        LOGGER.debug("health checks = {}", (Object)this.healthChecks.getNames());
    }
}

