/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.servlets.tasks;

import java.io.PrintWriter;
import java.util.List;
import java.util.Map;
import shadow.io.dropwizard.servlets.tasks.Task;

public class GarbageCollectionTask
extends Task {
    private final Runtime runtime;

    public GarbageCollectionTask() {
        this(Runtime.getRuntime());
    }

    public GarbageCollectionTask(Runtime runtime) {
        super("gc");
        this.runtime = runtime;
    }

    @Override
    public void execute(Map<String, List<String>> parameters, PrintWriter output) {
        int count = GarbageCollectionTask.parseRuns(parameters);
        for (int i = 0; i < count; ++i) {
            output.println("Running GC...");
            output.flush();
            this.runtime.gc();
        }
        output.println("Done!");
    }

    private static int parseRuns(Map<String, List<String>> parameters) {
        List<String> runs = parameters.get("runs");
        if (runs == null || runs.isEmpty()) {
            return 1;
        }
        try {
            return Integer.parseInt(runs.get(0));
        }
        catch (NumberFormatException ignored) {
            return 1;
        }
    }
}

