/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.request.logging;

import ch.qos.logback.access.spi.IAccessEvent;
import ch.qos.logback.classic.Logger;
import ch.qos.logback.classic.LoggerContext;
import java.util.Collections;
import java.util.List;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.annotation.JsonIgnore;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.com.fasterxml.jackson.annotation.JsonTypeName;
import shadow.io.dropwizard.logging.AppenderFactory;
import shadow.io.dropwizard.logging.ConsoleAppenderFactory;
import shadow.io.dropwizard.logging.filter.NullLevelFilterFactory;
import shadow.io.dropwizard.request.logging.LogbackAccessRequestLog;
import shadow.io.dropwizard.request.logging.RequestLogFactory;
import shadow.io.dropwizard.request.logging.async.AsyncAccessEventAppenderFactory;
import shadow.io.dropwizard.request.logging.layout.LogbackAccessRequestLayoutFactory;
import shadow.javax.validation.Valid;
import shadow.javax.validation.constraints.NotNull;
import shadow.org.eclipse.jetty.server.RequestLog;

@JsonTypeName(value="logback-access")
public class LogbackAccessRequestLogFactory
implements RequestLogFactory<RequestLog> {
    @Valid
    @NotNull
    private List<AppenderFactory<IAccessEvent>> appenders = Collections.singletonList(new ConsoleAppenderFactory());

    @JsonProperty
    public List<AppenderFactory<IAccessEvent>> getAppenders() {
        return this.appenders;
    }

    @JsonProperty
    public void setAppenders(List<AppenderFactory<IAccessEvent>> appenders) {
        this.appenders = appenders;
    }

    @Override
    @JsonIgnore
    public boolean isEnabled() {
        return !this.appenders.isEmpty();
    }

    @Override
    public RequestLog build(String name) {
        Logger logger = (Logger)LoggerFactory.getLogger("http.request");
        logger.setAdditive(false);
        LoggerContext context = logger.getLoggerContext();
        LogbackAccessRequestLog requestLog = new LogbackAccessRequestLog();
        NullLevelFilterFactory levelFilterFactory = new NullLevelFilterFactory();
        AsyncAccessEventAppenderFactory asyncAppenderFactory = new AsyncAccessEventAppenderFactory();
        LogbackAccessRequestLayoutFactory layoutFactory = new LogbackAccessRequestLayoutFactory();
        for (AppenderFactory<IAccessEvent> output : this.appenders) {
            requestLog.addAppender(output.build(context, name, layoutFactory, levelFilterFactory, asyncAppenderFactory));
        }
        return requestLog;
    }
}

