/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.metrics;

import shadow.com.codahale.metrics.ScheduledReporter;
import shadow.io.dropwizard.lifecycle.Managed;
import shadow.io.dropwizard.util.Duration;

public class ScheduledReporterManager
implements Managed {
    private final ScheduledReporter reporter;
    private final Duration period;
    private final boolean reportOnStop;

    public ScheduledReporterManager(ScheduledReporter reporter, Duration period) {
        this(reporter, period, false);
    }

    public ScheduledReporterManager(ScheduledReporter reporter, Duration period, boolean reportOnStop) {
        this.reporter = reporter;
        this.period = period;
        this.reportOnStop = reportOnStop;
    }

    @Override
    public void start() throws Exception {
        this.reporter.start(this.period.getQuantity(), this.period.getUnit());
    }

    @Override
    public void stop() throws Exception {
        try {
            if (this.reportOnStop) {
                this.reporter.report();
            }
        }
        finally {
            this.reporter.stop();
        }
    }
}

