/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.metrics;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.codahale.metrics.MetricRegistry;
import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.io.dropwizard.lifecycle.setup.LifecycleEnvironment;
import shadow.io.dropwizard.metrics.ReporterFactory;
import shadow.io.dropwizard.metrics.ScheduledReporterManager;
import shadow.io.dropwizard.util.Duration;
import shadow.javax.validation.Valid;
import shadow.javax.validation.constraints.NotNull;

public class MetricsFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(MetricsFactory.class);
    @Valid
    @NotNull
    private Duration frequency = Duration.minutes(1L);
    @Valid
    @NotNull
    private List<ReporterFactory> reporters = Collections.emptyList();
    private boolean reportOnStop = false;

    @JsonProperty
    public List<ReporterFactory> getReporters() {
        return this.reporters;
    }

    @JsonProperty
    public void setReporters(List<ReporterFactory> reporters) {
        this.reporters = new ArrayList<ReporterFactory>(reporters);
    }

    @JsonProperty
    public Duration getFrequency() {
        return this.frequency;
    }

    @JsonProperty
    public void setFrequency(Duration frequency) {
        this.frequency = frequency;
    }

    @JsonProperty
    public boolean isReportOnStop() {
        return this.reportOnStop;
    }

    @JsonProperty
    public void setReportOnStop(boolean reportOnStop) {
        this.reportOnStop = reportOnStop;
    }

    @JsonProperty
    public void configure(LifecycleEnvironment environment, MetricRegistry registry) {
        for (ReporterFactory reporter : this.reporters) {
            try {
                ScheduledReporterManager manager = new ScheduledReporterManager(reporter.build(registry), reporter.getFrequency().orElseGet(this::getFrequency), this.isReportOnStop());
                environment.manage(manager);
            }
            catch (Exception e) {
                LOGGER.warn("Failed to create reporter, metrics may not be properly reported.", e);
            }
        }
    }

    public String toString() {
        return "MetricsFactory{frequency=" + this.frequency + ", reporters=" + this.reporters + ", reportOnStop=" + this.reportOnStop + '}';
    }
}

