/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.logging;

import ch.qos.logback.classic.LoggerContext;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.ILoggerFactory;
import org.slf4j.LoggerFactory;
import shadow.io.dropwizard.util.Duration;
import shadow.javax.annotation.concurrent.GuardedBy;
import shadow.org.slf4j.bridge.SLF4JBridgeHandler;

public class LoggingUtil {
    private static final Duration LOGGER_CONTEXT_AWAITING_TIMEOUT = Duration.seconds(10L);
    private static final Duration LOGGER_CONTEXT_AWAITING_SLEEP_TIME = Duration.milliseconds(100L);
    @GuardedBy(value="JUL_HIJACKING_LOCK")
    private static boolean julHijacked = false;
    private static final Lock JUL_HIJACKING_LOCK = new ReentrantLock();

    private LoggingUtil() {
    }

    public static LoggerContext getLoggerContext() {
        long startTime = System.nanoTime();
        ILoggerFactory iLoggerFactory;
        while (!((iLoggerFactory = LoggerFactory.getILoggerFactory()) instanceof LoggerContext)) {
            if (System.nanoTime() - startTime > LOGGER_CONTEXT_AWAITING_TIMEOUT.toNanoseconds()) {
                throw new IllegalStateException("Unable to acquire the logger context");
            }
            try {
                Thread.sleep(LOGGER_CONTEXT_AWAITING_SLEEP_TIME.toMilliseconds());
            }
            catch (InterruptedException e) {
                throw new IllegalStateException(e);
            }
        }
        return (LoggerContext)iLoggerFactory;
    }

    public static void hijackJDKLogging() {
        JUL_HIJACKING_LOCK.lock();
        try {
            if (!julHijacked) {
                SLF4JBridgeHandler.removeHandlersForRootLogger();
                SLF4JBridgeHandler.install();
                julHijacked = true;
            }
        }
        finally {
            JUL_HIJACKING_LOCK.unlock();
        }
    }
}

