/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.logback;

import ch.qos.logback.core.Appender;
import ch.qos.logback.core.AsyncAppenderBase;
import ch.qos.logback.core.Context;
import ch.qos.logback.core.LogbackException;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.spi.DeferredProcessingAware;
import ch.qos.logback.core.spi.FilterReply;
import ch.qos.logback.core.status.Status;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import shadow.io.dropwizard.logback.AsyncAppenderBaseProxy;
import shadow.io.dropwizard.logback.shaded.guava.util.concurrent.RateLimiter;

public class ThrottlingAppenderWrapper<E extends DeferredProcessingAware>
implements Appender<E>,
AsyncAppenderBaseProxy<E> {
    private final AsyncAppenderBase<E> appender;
    private final RateLimiter rateLimiter;

    public ThrottlingAppenderWrapper(AsyncAppenderBase<E> delegate, long messageRate, TimeUnit rateUnit) {
        this.appender = Objects.requireNonNull(delegate, "delegate must not be null!");
        if (messageRate <= 0L) {
            throw new IllegalArgumentException("messageRate must be positive!");
        }
        this.rateLimiter = RateLimiter.create(1.0E9 / (double)rateUnit.toNanos(messageRate));
    }

    @Override
    public AsyncAppenderBase<E> getAppender() {
        return this.appender;
    }

    @Override
    public void start() {
        this.appender.start();
    }

    @Override
    public void stop() {
        this.appender.stop();
    }

    @Override
    public boolean isStarted() {
        return this.appender.isStarted();
    }

    @Override
    public void doAppend(E event) throws LogbackException {
        if (this.rateLimiter.tryAcquire()) {
            this.appender.doAppend(event);
        }
    }

    @Override
    public String getName() {
        return this.appender.getName();
    }

    @Override
    public void setName(String name) {
        this.appender.setName(name);
    }

    @Override
    public Context getContext() {
        return this.appender.getContext();
    }

    @Override
    public void setContext(Context context) {
        this.appender.setContext(context);
    }

    @Override
    public void addStatus(Status status) {
        this.appender.addStatus(status);
    }

    @Override
    public void addInfo(String msg) {
        this.appender.addInfo(msg);
    }

    @Override
    public void addInfo(String msg, Throwable ex) {
        this.appender.addInfo(msg, ex);
    }

    @Override
    public void addWarn(String msg) {
        this.appender.addWarn(msg);
    }

    @Override
    public void addWarn(String msg, Throwable ex) {
        this.appender.addWarn(msg, ex);
    }

    @Override
    public void addError(String msg) {
        this.appender.addError(msg);
    }

    @Override
    public void addError(String msg, Throwable ex) {
        this.appender.addError(msg, ex);
    }

    @Override
    public void addFilter(Filter<E> newFilter) {
        this.appender.addFilter(newFilter);
    }

    @Override
    public void clearAllFilters() {
        this.appender.clearAllFilters();
    }

    @Override
    public List<Filter<E>> getCopyOfAttachedFiltersList() {
        return this.appender.getCopyOfAttachedFiltersList();
    }

    @Override
    public FilterReply getFilterChainDecision(E event) {
        return this.appender.getFilterChainDecision(event);
    }

    public String toString() {
        return this.getClass().getName() + "[" + this.getName() + "]";
    }
}

