/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jetty;

import java.util.List;
import java.util.Objects;
import shadow.com.codahale.metrics.Timer;
import shadow.javax.annotation.Nullable;
import shadow.org.eclipse.jetty.io.Connection;
import shadow.org.eclipse.jetty.io.EndPoint;
import shadow.org.eclipse.jetty.server.ConnectionFactory;
import shadow.org.eclipse.jetty.server.Connector;
import shadow.org.eclipse.jetty.util.component.ContainerLifeCycle;

public class Jetty93InstrumentedConnectionFactory
extends ContainerLifeCycle
implements ConnectionFactory {
    private final ConnectionFactory connectionFactory;
    private final Timer timer;

    public Jetty93InstrumentedConnectionFactory(ConnectionFactory connectionFactory, Timer timer) {
        this.connectionFactory = connectionFactory;
        this.timer = timer;
        this.addBean(connectionFactory);
    }

    public ConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    public Timer getTimer() {
        return this.timer;
    }

    @Override
    public String getProtocol() {
        return this.connectionFactory.getProtocol();
    }

    @Override
    public List<String> getProtocols() {
        return this.connectionFactory.getProtocols();
    }

    @Override
    public Connection newConnection(Connector connector, EndPoint endPoint) {
        Connection connection = this.connectionFactory.newConnection(connector, endPoint);
        connection.addListener(new Connection.Listener(){
            @Nullable
            private Timer.Context context;

            @Override
            public void onOpened(Connection connection) {
                this.context = Jetty93InstrumentedConnectionFactory.this.timer.time();
            }

            @Override
            public void onClosed(Connection connection) {
                Objects.requireNonNull(this.context).stop();
            }
        });
        return connection;
    }
}

