/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.validation;

import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.io.dropwizard.jersey.validation.ConstraintMessage;
import shadow.io.dropwizard.jersey.validation.JerseyViolationException;
import shadow.io.dropwizard.jersey.validation.ValidationErrorMessage;
import shadow.javax.validation.ConstraintViolation;
import shadow.javax.ws.rs.core.Response;
import shadow.javax.ws.rs.ext.ExceptionMapper;
import shadow.javax.ws.rs.ext.Provider;
import shadow.org.glassfish.jersey.server.model.Invocable;

@Provider
public class JerseyViolationExceptionMapper
implements ExceptionMapper<JerseyViolationException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(JerseyViolationExceptionMapper.class);

    @Override
    public Response toResponse(JerseyViolationException exception) {
        LOGGER.debug("Object validation failure", exception);
        Set<ConstraintViolation<?>> violations = exception.getConstraintViolations();
        Invocable invocable = exception.getInvocable();
        List<String> errors = exception.getConstraintViolations().stream().map(violation -> ConstraintMessage.getMessage(violation, invocable)).collect(Collectors.toList());
        int status = ConstraintMessage.determineStatus(violations, invocable);
        return Response.status(status).entity(new ValidationErrorMessage(errors)).build();
    }
}

