/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.validation;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.security.AccessController;
import shadow.io.dropwizard.jersey.validation.FuzzyEnumParamConverter;
import shadow.io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import shadow.javax.annotation.Nullable;
import shadow.javax.ws.rs.ext.ParamConverter;
import shadow.javax.ws.rs.ext.ParamConverterProvider;
import shadow.javax.ws.rs.ext.Provider;
import shadow.org.glassfish.jersey.internal.util.ReflectionHelper;

@Provider
public class FuzzyEnumParamConverterProvider
implements ParamConverterProvider {
    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, @Nullable Type genericType, Annotation[] annotations) {
        if (!rawType.isEnum()) {
            return null;
        }
        Class<T> type = rawType;
        Enum[] constants = (Enum[])type.getEnumConstants();
        String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse("Parameter");
        Method fromStringMethod = AccessController.doPrivileged(ReflectionHelper.getFromStringStringMethodPA(rawType));
        return new FuzzyEnumParamConverter<T>(rawType, fromStringMethod, constants, parameterName);
    }
}

