/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.validation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Objects;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.io.dropwizard.jersey.validation.JerseyViolationException;
import shadow.io.dropwizard.validation.ConstraintViolations;
import shadow.io.dropwizard.validation.Validated;
import shadow.javax.validation.ConstraintViolation;
import shadow.javax.validation.ConstraintViolationException;
import shadow.javax.validation.Validator;
import shadow.javax.validation.executable.ExecutableValidator;
import shadow.javax.validation.groups.Default;
import shadow.javax.validation.metadata.BeanDescriptor;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.org.glassfish.jersey.server.internal.inject.ConfiguredValidator;
import shadow.org.glassfish.jersey.server.model.Invocable;
import shadow.org.glassfish.jersey.server.model.Parameter;

public class DropwizardConfiguredValidator
implements ConfiguredValidator {
    private static final Logger LOGGER = LoggerFactory.getLogger(DropwizardConfiguredValidator.class);
    private final Validator validator;

    public DropwizardConfiguredValidator(Validator validator) {
        this.validator = Objects.requireNonNull(validator);
    }

    @Override
    public void validateResourceAndInputParams(Object resource, Invocable invocable, Object[] objects) throws ConstraintViolationException {
        Class<?>[] groups = this.getGroup(invocable);
        HashSet<ConstraintViolation<Object>> violations = new HashSet<ConstraintViolation<Object>>();
        BeanDescriptor beanDescriptor = this.getConstraintsForClass(resource.getClass());
        if (beanDescriptor.isBeanConstrained()) {
            violations.addAll(this.validate(resource, groups));
        }
        violations.addAll(this.forExecutables().validateParameters(resource, invocable.getHandlingMethod(), objects, groups));
        if (!violations.isEmpty()) {
            throw new JerseyViolationException(violations, invocable);
        }
    }

    private Class<?>[] getGroup(Invocable invocable) {
        ArrayList<Class<?>[]> groups = new ArrayList<Class<?>[]>();
        for (Parameter parameter : invocable.getParameters()) {
            if (!parameter.isAnnotationPresent(Validated.class)) continue;
            groups.add(parameter.getAnnotation(Validated.class).value());
        }
        switch (groups.size()) {
            case 0: {
                return new Class[]{Default.class};
            }
            case 1: {
                return (Class[])groups.get(0);
            }
        }
        for (int i = 0; i < groups.size(); ++i) {
            for (int j = i; j < groups.size(); ++j) {
                if (Arrays.deepEquals((Object[])groups.get(i), (Object[])groups.get(j))) continue;
                throw new WebApplicationException("Parameters must have the same validation groups in " + invocable.getHandlingMethod().getName(), 500);
            }
        }
        return (Class[])groups.get(0);
    }

    @Override
    public void validateResult(Object resource, Invocable invocable, Object returnValue) throws ConstraintViolationException {
        Class<Object>[] groups = invocable.getHandlingMethod().isAnnotationPresent(Validated.class) ? invocable.getHandlingMethod().getAnnotation(Validated.class).value() : new Class[]{Default.class};
        Set violations = this.forExecutables().validateReturnValue(resource, invocable.getHandlingMethod(), returnValue, groups);
        if (!violations.isEmpty()) {
            LOGGER.trace("Response validation failed: {}", (Object)ConstraintViolations.copyOf(violations));
            throw new JerseyViolationException(violations, invocable);
        }
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validate(T t, Class<?> ... classes) {
        return this.validator.validate(t, classes);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateProperty(T t, String s, Class<?> ... classes) {
        return this.validator.validateProperty(t, s, classes);
    }

    @Override
    public <T> Set<ConstraintViolation<T>> validateValue(Class<T> aClass, String s, Object o, Class<?> ... classes) {
        return this.validator.validateValue(aClass, s, o, classes);
    }

    @Override
    public BeanDescriptor getConstraintsForClass(Class<?> aClass) {
        return this.validator.getConstraintsForClass(aClass);
    }

    @Override
    public <T> T unwrap(Class<T> aClass) {
        return this.validator.unwrap(aClass);
    }

    @Override
    public ExecutableValidator forExecutables() {
        return this.validator.forExecutables();
    }
}

