/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.sessions;

import java.util.function.Function;
import shadow.io.dropwizard.jersey.sessions.Flash;
import shadow.io.dropwizard.jersey.sessions.FlashFactory;
import shadow.io.dropwizard.jersey.sessions.HttpSessionFactory;
import shadow.io.dropwizard.jersey.sessions.Session;
import shadow.javax.annotation.Nullable;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Provider;
import shadow.javax.inject.Singleton;
import shadow.javax.servlet.http.HttpSession;
import shadow.org.glassfish.jersey.internal.inject.AbstractBinder;
import shadow.org.glassfish.jersey.internal.inject.ClassBinding;
import shadow.org.glassfish.jersey.internal.inject.InjectionManager;
import shadow.org.glassfish.jersey.model.Parameter;
import shadow.org.glassfish.jersey.server.ContainerRequest;
import shadow.org.glassfish.jersey.server.internal.inject.AbstractValueParamProvider;
import shadow.org.glassfish.jersey.server.internal.inject.MultivaluedParameterExtractorProvider;
import shadow.org.glassfish.jersey.server.model.Parameter;
import shadow.org.glassfish.jersey.server.spi.internal.ValueParamProvider;

@Singleton
public class SessionFactoryProvider
extends AbstractValueParamProvider {
    private final InjectionManager im;

    @Inject
    public SessionFactoryProvider(Provider<MultivaluedParameterExtractorProvider> extractorProvider, InjectionManager im) {
        super(extractorProvider, Parameter.Source.UNKNOWN);
        this.im = im;
    }

    @Override
    @Nullable
    protected Function<ContainerRequest, ?> createValueProvider(Parameter parameter) {
        Class<Object> classType = parameter.getRawType();
        Session sessionAnnotation = parameter.getAnnotation(Session.class);
        if (sessionAnnotation == null) {
            return null;
        }
        if (classType.isAssignableFrom(HttpSession.class)) {
            return x -> this.im.createAndInitialize(HttpSessionFactory.class).provide(sessionAnnotation.doNotCreate());
        }
        if (classType.isAssignableFrom(Flash.class)) {
            return x -> this.im.createAndInitialize(FlashFactory.class).provide(sessionAnnotation.doNotCreate());
        }
        return null;
    }

    public static class Binder
    extends AbstractBinder {
        @Override
        protected void configure() {
            ((ClassBinding)this.bind(SessionFactoryProvider.class).to(ValueParamProvider.class)).in(Singleton.class);
        }
    }
}

