/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.params;

import java.lang.annotation.Annotation;
import java.lang.reflect.Constructor;
import java.lang.reflect.Type;
import shadow.io.dropwizard.jersey.DefaultValueUtils;
import shadow.io.dropwizard.jersey.params.AbstractParam;
import shadow.io.dropwizard.jersey.params.AbstractParamConverter;
import shadow.io.dropwizard.jersey.validation.JerseyParameterNameProvider;
import shadow.javax.annotation.Nullable;
import shadow.javax.ws.rs.ext.ParamConverter;
import shadow.javax.ws.rs.ext.ParamConverterProvider;

public class AbstractParamConverterProvider
implements ParamConverterProvider {
    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (AbstractParam.class.isAssignableFrom(rawType)) {
            Constructor<T> constructor;
            String parameterName = JerseyParameterNameProvider.getParameterNameFromAnnotations(annotations).orElse("Parameter");
            try {
                constructor = rawType.getConstructor(String.class, String.class);
            }
            catch (NoSuchMethodException ignored) {
                return null;
            }
            String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
            return new AbstractParamConverter<T>(constructor, parameterName, defaultValue);
        }
        return null;
    }
}

