/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.params;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import shadow.io.dropwizard.util.Strings;
import shadow.javax.annotation.Nullable;
import shadow.javax.ws.rs.ProcessingException;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.javax.ws.rs.ext.ParamConverter;
import shadow.org.glassfish.jersey.internal.inject.ExtractorException;
import shadow.org.glassfish.jersey.server.internal.LocalizationMessages;

public class AbstractParamConverter<T>
implements ParamConverter<T> {
    private final Constructor<T> constructor;
    private final String parameterName;
    @Nullable
    private final String defaultValue;

    public AbstractParamConverter(Constructor<T> constructor, String parameterName, @Nullable String defaultValue) {
        this.constructor = constructor;
        this.parameterName = parameterName;
        this.defaultValue = defaultValue;
    }

    @Override
    @Nullable
    public T fromString(String value) {
        try {
            if (Strings.isNullOrEmpty(value) && this.defaultValue != null && !this.defaultValue.equals(value)) {
                return this._fromString(this.defaultValue);
            }
            return this._fromString(value);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getCause();
            if (cause instanceof WebApplicationException) {
                throw (WebApplicationException)cause;
            }
            throw new ExtractorException(cause);
        }
        catch (Exception ex) {
            throw new ProcessingException(ex);
        }
    }

    private T _fromString(String value) throws Exception {
        return this.constructor.newInstance(value, this.parameterName);
    }

    @Override
    public String toString(T value) throws IllegalArgumentException {
        if (value == null) {
            throw new IllegalArgumentException(LocalizationMessages.METHOD_PARAMETER_CANNOT_BE_NULL("value"));
        }
        return value.toString();
    }
}

