/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.optional;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Optional;
import shadow.javax.annotation.Nullable;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.ext.ParamConverter;
import shadow.javax.ws.rs.ext.ParamConverterProvider;
import shadow.org.glassfish.jersey.internal.inject.InjectionManager;
import shadow.org.glassfish.jersey.internal.inject.Providers;
import shadow.org.glassfish.jersey.internal.util.ReflectionHelper;
import shadow.org.glassfish.jersey.internal.util.collection.ClassTypePair;

@Singleton
public class OptionalParamConverterProvider
implements ParamConverterProvider {
    private final InjectionManager manager;

    @Inject
    public OptionalParamConverterProvider(InjectionManager manager) {
        this.manager = manager;
    }

    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(final Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (Optional.class.equals(rawType)) {
            ClassTypePair ctp;
            List<ClassTypePair> ctps = ReflectionHelper.getTypeArgumentAndClass(genericType);
            ClassTypePair classTypePair = ctp = ctps.size() == 1 ? ctps.get(0) : null;
            if (ctp == null || ctp.rawClass() == String.class) {
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value) {
                        return rawType.cast(Optional.ofNullable(value));
                    }

                    @Override
                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
            for (ParamConverterProvider provider : Providers.getProviders(this.manager, ParamConverterProvider.class)) {
                final ParamConverter<?> converter = provider.getConverter(ctp.rawClass(), ctp.type(), annotations);
                if (converter == null) continue;
                return new ParamConverter<T>(){

                    @Override
                    public T fromString(String value) {
                        return rawType.cast(Optional.ofNullable(value).map(s -> converter.fromString(value)));
                    }

                    @Override
                    public String toString(T value) {
                        return value.toString();
                    }
                };
            }
        }
        return null;
    }
}

