/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.optional;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalLong;
import shadow.io.dropwizard.jersey.DefaultValueUtils;
import shadow.javax.annotation.Nullable;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.ext.ParamConverter;
import shadow.javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalLongParamConverterProvider
implements ParamConverterProvider {
    private final OptionalLongParamConverter paramConverter = new OptionalLongParamConverter();

    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!OptionalLong.class.equals(rawType)) {
            return null;
        }
        String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
        return defaultValue == null ? this.paramConverter : new OptionalLongParamConverter(defaultValue);
    }

    public static class OptionalLongParamConverter
    implements ParamConverter<OptionalLong> {
        @Nullable
        private final String defaultValue;

        public OptionalLongParamConverter() {
            this(null);
        }

        public OptionalLongParamConverter(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Nullable
        public OptionalLong fromString(String value) {
            try {
                long l = Long.parseLong(value);
                return OptionalLong.of(l);
            }
            catch (NullPointerException | NumberFormatException e) {
                if (this.defaultValue != null) {
                    if (this.defaultValue.equals(value)) {
                        throw e;
                    }
                    if (value == null || value.isEmpty()) {
                        return null;
                    }
                }
                return OptionalLong.empty();
            }
        }

        @Override
        public String toString(OptionalLong value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Long.toString(value.getAsLong()) : "";
        }
    }
}

