/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.optional;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.OptionalLong;
import shadow.io.dropwizard.jersey.optional.EmptyOptionalException;
import shadow.javax.ws.rs.Produces;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.MultivaluedMap;
import shadow.javax.ws.rs.ext.MessageBodyWriter;
import shadow.javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"*/*"})
public class OptionalLongMessageBodyWriter
implements MessageBodyWriter<OptionalLong> {
    @Override
    public long getSize(OptionalLong entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OptionalLong.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(OptionalLong entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (!entity.isPresent()) {
            throw EmptyOptionalException.INSTANCE;
        }
        entityStream.write(Long.toString(entity.getAsLong()).getBytes(StandardCharsets.US_ASCII));
    }
}

