/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.optional;

import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.OptionalInt;
import shadow.io.dropwizard.jersey.DefaultValueUtils;
import shadow.javax.annotation.Nullable;
import shadow.javax.inject.Singleton;
import shadow.javax.ws.rs.ext.ParamConverter;
import shadow.javax.ws.rs.ext.ParamConverterProvider;

@Singleton
public class OptionalIntParamConverterProvider
implements ParamConverterProvider {
    private final OptionalIntParamConverter paramConverter = new OptionalIntParamConverter();

    @Override
    @Nullable
    public <T> ParamConverter<T> getConverter(Class<T> rawType, Type genericType, Annotation[] annotations) {
        if (!OptionalInt.class.equals(rawType)) {
            return null;
        }
        String defaultValue = DefaultValueUtils.getDefaultValue(annotations);
        return defaultValue == null ? this.paramConverter : new OptionalIntParamConverter(defaultValue);
    }

    public static class OptionalIntParamConverter
    implements ParamConverter<OptionalInt> {
        @Nullable
        private final String defaultValue;

        public OptionalIntParamConverter() {
            this(null);
        }

        public OptionalIntParamConverter(@Nullable String defaultValue) {
            this.defaultValue = defaultValue;
        }

        @Override
        @Nullable
        public OptionalInt fromString(String value) {
            try {
                int i = Integer.parseInt(value);
                return OptionalInt.of(i);
            }
            catch (NullPointerException | NumberFormatException e) {
                if (this.defaultValue != null) {
                    if (this.defaultValue.equals(value)) {
                        throw e;
                    }
                    if (value == null || value.isEmpty()) {
                        return null;
                    }
                }
                return OptionalInt.empty();
            }
        }

        @Override
        public String toString(OptionalInt value) {
            if (value == null) {
                throw new IllegalArgumentException("value must not be null");
            }
            return value.isPresent() ? Integer.toString(value.getAsInt()) : "";
        }
    }
}

