/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.optional;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.OptionalInt;
import shadow.io.dropwizard.jersey.optional.EmptyOptionalException;
import shadow.javax.ws.rs.Produces;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.MultivaluedMap;
import shadow.javax.ws.rs.ext.MessageBodyWriter;
import shadow.javax.ws.rs.ext.Provider;

@Provider
@Produces(value={"*/*"})
public class OptionalIntMessageBodyWriter
implements MessageBodyWriter<OptionalInt> {
    @Override
    public long getSize(OptionalInt entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return -1L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return OptionalInt.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(OptionalInt entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (!entity.isPresent()) {
            throw EmptyOptionalException.INSTANCE;
        }
        entityStream.write(Integer.toString(entity.getAsInt()).getBytes(StandardCharsets.US_ASCII));
    }
}

