/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.jackson;

import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.core.JsonGenerationException;
import shadow.com.fasterxml.jackson.core.JsonProcessingException;
import shadow.com.fasterxml.jackson.databind.exc.InvalidDefinitionException;
import shadow.io.dropwizard.jersey.errors.ErrorMessage;
import shadow.io.dropwizard.jersey.errors.LoggingExceptionMapper;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.Response;
import shadow.javax.ws.rs.ext.Provider;

@Provider
public class JsonProcessingExceptionMapper
extends LoggingExceptionMapper<JsonProcessingException> {
    private final boolean showDetails;

    public JsonProcessingExceptionMapper() {
        this(false);
    }

    public JsonProcessingExceptionMapper(boolean showDetails) {
        super(LoggerFactory.getLogger(JsonProcessingExceptionMapper.class));
        this.showDetails = showDetails;
    }

    public boolean isShowDetails() {
        return this.showDetails;
    }

    @Override
    public Response toResponse(JsonProcessingException exception) {
        if (exception instanceof JsonGenerationException || exception instanceof InvalidDefinitionException) {
            return super.toResponse(exception);
        }
        this.logger.debug("Unable to process JSON", exception);
        String message = exception.getOriginalMessage();
        ErrorMessage errorMessage = new ErrorMessage(Response.Status.BAD_REQUEST.getStatusCode(), "Unable to process JSON", this.showDetails ? message : null);
        return Response.status(Response.Status.BAD_REQUEST).type(MediaType.APPLICATION_JSON_TYPE).entity(errorMessage).build();
    }
}

