/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.guava;

import java.io.IOException;
import java.io.OutputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Objects;
import shadow.com.google.common.base.Optional;
import shadow.io.dropwizard.jersey.optional.EmptyOptionalException;
import shadow.javax.annotation.Nullable;
import shadow.javax.inject.Inject;
import shadow.javax.inject.Provider;
import shadow.javax.ws.rs.Produces;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.MultivaluedMap;
import shadow.javax.ws.rs.ext.MessageBodyWriter;
import shadow.org.glassfish.jersey.message.MessageBodyWorkers;

@shadow.javax.ws.rs.ext.Provider
@Produces(value={"*/*"})
public class OptionalMessageBodyWriter
implements MessageBodyWriter<Optional<?>> {
    @Inject
    @Nullable
    private Provider<MessageBodyWorkers> mbw;

    @Override
    public long getSize(Optional<?> entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return 0L;
    }

    @Override
    public boolean isWriteable(Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType) {
        return Optional.class.isAssignableFrom(type);
    }

    @Override
    public void writeTo(Optional<?> entity, Class<?> type, Type genericType, Annotation[] annotations, MediaType mediaType, MultivaluedMap<String, Object> httpHeaders, OutputStream entityStream) throws IOException {
        if (!entity.isPresent()) {
            throw EmptyOptionalException.INSTANCE;
        }
        ParameterizedType actualGenericType = (ParameterizedType)genericType;
        Type actualGenericTypeArgument = actualGenericType.getActualTypeArguments()[0];
        MessageBodyWriter<?> writer = Objects.requireNonNull(this.mbw).get().getMessageBodyWriter(entity.get().getClass(), actualGenericTypeArgument, annotations, mediaType);
        writer.writeTo(entity.get(), entity.get().getClass(), actualGenericTypeArgument, annotations, mediaType, httpHeaders, entityStream);
    }
}

