/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.filter;

import java.io.IOException;
import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.io.dropwizard.util.Sets;
import shadow.javax.servlet.Filter;
import shadow.javax.servlet.FilterChain;
import shadow.javax.servlet.FilterConfig;
import shadow.javax.servlet.ServletException;
import shadow.javax.servlet.ServletRequest;
import shadow.javax.servlet.ServletResponse;
import shadow.javax.servlet.http.HttpServletRequest;
import shadow.javax.servlet.http.HttpServletResponse;

public class AllowedMethodsFilter
implements Filter {
    public static final String ALLOWED_METHODS_PARAM = "allowedMethods";
    public static final Set<String> DEFAULT_ALLOWED_METHODS = Sets.of("GET", "POST", "PUT", "DELETE", "HEAD", "OPTIONS", "PATCH");
    private static final Logger LOG = LoggerFactory.getLogger(AllowedMethodsFilter.class);
    private Set<String> allowedMethods = Collections.emptySet();

    @Override
    public void init(FilterConfig config) {
        this.allowedMethods = Optional.ofNullable(config.getInitParameter(ALLOWED_METHODS_PARAM)).map(p -> Sets.of(p.split(","))).orElse(DEFAULT_ALLOWED_METHODS);
    }

    @Override
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        this.handle((HttpServletRequest)request, (HttpServletResponse)response, chain);
    }

    private void handle(HttpServletRequest request, HttpServletResponse response, FilterChain chain) throws IOException, ServletException {
        if (this.allowedMethods.contains(request.getMethod())) {
            chain.doFilter(request, response);
        } else {
            LOG.debug("Request with disallowed method {} blocked", (Object)request.getMethod());
            response.sendError(405);
        }
    }

    @Override
    public void destroy() {
    }
}

