/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.errors;

import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.ThreadLocalRandom;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.io.dropwizard.jersey.errors.ErrorMessage;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.Response;
import shadow.javax.ws.rs.ext.ExceptionMapper;
import shadow.javax.ws.rs.ext.Provider;

@Provider
public abstract class LoggingExceptionMapper<E extends Throwable>
implements ExceptionMapper<E> {
    protected final Logger logger;

    protected LoggingExceptionMapper(Logger logger) {
        this.logger = Objects.requireNonNull(logger, "logger");
    }

    public LoggingExceptionMapper() {
        this(LoggerFactory.getLogger(LoggingExceptionMapper.class));
    }

    @Override
    public Response toResponse(E exception) {
        if (exception instanceof WebApplicationException) {
            Response response = ((WebApplicationException)exception).getResponse();
            Response.Status.Family family = response.getStatusInfo().getFamily();
            if (family.equals((Object)Response.Status.Family.REDIRECTION)) {
                return response;
            }
            if (family.equals((Object)Response.Status.Family.SERVER_ERROR)) {
                this.logException(exception);
            }
            return Response.fromResponse(response).type(MediaType.APPLICATION_JSON_TYPE).entity(new ErrorMessage(response.getStatus(), ((Throwable)exception).getLocalizedMessage())).build();
        }
        long id = this.logException(exception);
        return Response.status(Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()).type(MediaType.APPLICATION_JSON_TYPE).entity(new ErrorMessage(this.formatErrorMessage(id, exception))).build();
    }

    protected String formatErrorMessage(long id, E exception) {
        return String.format(Locale.ROOT, "There was an error processing your request. It has been logged (ID %016x).", id);
    }

    protected long logException(E exception) {
        long id = ThreadLocalRandom.current().nextLong();
        this.logException(id, exception);
        return id;
    }

    protected void logException(long id, E exception) {
        this.logger.error(this.formatLogMessage(id, (Throwable)exception), (Throwable)exception);
    }

    protected String formatLogMessage(long id, Throwable exception) {
        return String.format(Locale.ROOT, "Error handling a request: %016x", id);
    }
}

