/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.errors;

import org.slf4j.LoggerFactory;
import shadow.io.dropwizard.jersey.errors.ErrorMessage;
import shadow.io.dropwizard.jersey.errors.LoggingExceptionMapper;
import shadow.javax.ws.rs.NotSupportedException;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.javax.ws.rs.core.MediaType;
import shadow.javax.ws.rs.core.Response;
import shadow.javax.ws.rs.ext.Provider;
import shadow.org.glassfish.jersey.server.internal.LocalizationMessages;

@Provider
public class IllegalStateExceptionMapper
extends LoggingExceptionMapper<IllegalStateException> {
    public IllegalStateExceptionMapper() {
        super(LoggerFactory.getLogger(IllegalStateExceptionMapper.class));
    }

    @Override
    public Response toResponse(IllegalStateException exception) {
        String message = exception.getMessage();
        if (LocalizationMessages.FORM_PARAM_CONTENT_TYPE_ERROR().equals(message)) {
            this.logger.debug("If the HTTP method is POST and using @FormParam in a resource method, Content-Type should be application/x-www-form-urlencoded.", exception);
            return this.createResponse(new NotSupportedException());
        }
        return super.toResponse(exception);
    }

    private Response createResponse(WebApplicationException exception) {
        ErrorMessage errorMessage = new ErrorMessage(exception.getResponse().getStatus(), exception.getLocalizedMessage());
        return Response.status(errorMessage.getCode()).type(MediaType.APPLICATION_JSON_TYPE).entity(errorMessage).build();
    }
}

