/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.errors;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.codahale.metrics.Counter;
import shadow.com.codahale.metrics.MetricRegistry;
import shadow.javax.annotation.Priority;
import shadow.javax.inject.Inject;
import shadow.javax.ws.rs.WebApplicationException;
import shadow.javax.ws.rs.ext.Provider;
import shadow.javax.ws.rs.ext.WriterInterceptor;
import shadow.javax.ws.rs.ext.WriterInterceptorContext;
import shadow.org.eclipse.jetty.io.EofException;

@Provider
@Priority(value=0x7FFFFFFF)
public class EofExceptionWriterInterceptor
implements WriterInterceptor {
    private static final Logger LOGGER = LoggerFactory.getLogger(EofExceptionWriterInterceptor.class);
    private final Counter exceptionCounter;

    @Inject
    public EofExceptionWriterInterceptor(MetricRegistry metricRegistry) {
        this.exceptionCounter = metricRegistry.counter(MetricRegistry.name(this.getClass(), "eof-exceptions"));
    }

    @Override
    public void aroundWriteTo(WriterInterceptorContext context) throws IOException, WebApplicationException {
        try {
            context.proceed();
        }
        catch (EofException e) {
            LOGGER.debug("Client disconnected while processing and sending response", e);
            this.exceptionCounter.inc();
        }
    }
}

