/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jersey.errors;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.javax.ws.rs.core.Response;
import shadow.javax.ws.rs.ext.ExceptionMapper;
import shadow.javax.ws.rs.ext.Provider;
import shadow.org.eclipse.jetty.io.EofException;

@Provider
public class EarlyEofExceptionMapper
implements ExceptionMapper<EofException> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EarlyEofExceptionMapper.class);

    @Override
    public Response toResponse(EofException e) {
        LOGGER.debug("EOF Exception encountered - client disconnected during stream processing.", e);
        return Response.status(Response.Status.BAD_REQUEST).build();
    }
}

