/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jackson;

import shadow.com.fasterxml.jackson.core.JsonFactory;
import shadow.com.fasterxml.jackson.databind.DeserializationFeature;
import shadow.com.fasterxml.jackson.databind.ObjectMapper;
import shadow.com.fasterxml.jackson.datatype.guava.GuavaModule;
import shadow.com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import shadow.com.fasterxml.jackson.datatype.joda.JodaModule;
import shadow.com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import shadow.com.fasterxml.jackson.module.afterburner.AfterburnerModule;
import shadow.com.fasterxml.jackson.module.paramnames.ParameterNamesModule;
import shadow.io.dropwizard.jackson.AnnotationSensitivePropertyNamingStrategy;
import shadow.io.dropwizard.jackson.CaffeineModule;
import shadow.io.dropwizard.jackson.DiscoverableSubtypeResolver;
import shadow.io.dropwizard.jackson.FuzzyEnumModule;
import shadow.io.dropwizard.jackson.GuavaExtrasModule;
import shadow.io.dropwizard.util.JavaVersion;
import shadow.javax.annotation.Nullable;

public class Jackson {
    private Jackson() {
    }

    public static ObjectMapper newObjectMapper() {
        ObjectMapper mapper = new ObjectMapper();
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newObjectMapper(@Nullable JsonFactory jsonFactory) {
        ObjectMapper mapper = new ObjectMapper(jsonFactory);
        return Jackson.configure(mapper);
    }

    public static ObjectMapper newMinimalObjectMapper() {
        return new ObjectMapper().registerModule(new GuavaModule()).setSubtypeResolver(new DiscoverableSubtypeResolver()).disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
    }

    private static ObjectMapper configure(ObjectMapper mapper) {
        mapper.registerModule(new GuavaModule());
        mapper.registerModule(new GuavaExtrasModule());
        mapper.registerModule(new CaffeineModule());
        mapper.registerModule(new JodaModule());
        if (JavaVersion.isJava8()) {
            mapper.registerModule(new AfterburnerModule());
        }
        mapper.registerModule(new FuzzyEnumModule());
        mapper.registerModule(new ParameterNamesModule());
        mapper.registerModule(new Jdk8Module());
        mapper.registerModule(new JavaTimeModule());
        mapper.setPropertyNamingStrategy(new AnnotationSensitivePropertyNamingStrategy());
        mapper.setSubtypeResolver(new DiscoverableSubtypeResolver());
        mapper.disable(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES);
        return mapper;
    }
}

