/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jackson;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.Version;
import shadow.com.fasterxml.jackson.databind.BeanDescription;
import shadow.com.fasterxml.jackson.databind.DeserializationConfig;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.com.fasterxml.jackson.databind.Module;
import shadow.com.fasterxml.jackson.databind.SerializationConfig;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.deser.Deserializers;
import shadow.com.fasterxml.jackson.databind.ser.Serializers;
import shadow.com.google.common.cache.CacheBuilderSpec;

public class GuavaExtrasModule
extends Module {
    @Override
    public String getModuleName() {
        return "guava-extras";
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addDeserializers(new GuavaExtrasDeserializers());
        context.addSerializers(new GuavaExtrasSerializers());
    }

    private static class GuavaExtrasSerializers
    extends Serializers.Base {
        private GuavaExtrasSerializers() {
        }

        @Override
        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            if (CacheBuilderSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CacheBuilderSpecSerializer();
            }
            return super.findSerializer(config, type, beanDesc);
        }
    }

    private static class GuavaExtrasDeserializers
    extends Deserializers.Base {
        private GuavaExtrasDeserializers() {
        }

        @Override
        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (CacheBuilderSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CacheBuilderSpecDeserializer();
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }
    }

    private static class CacheBuilderSpecSerializer
    extends JsonSerializer<CacheBuilderSpec> {
        private CacheBuilderSpecSerializer() {
        }

        @Override
        public void serialize(CacheBuilderSpec value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toParsableString());
        }
    }

    private static class CacheBuilderSpecDeserializer
    extends JsonDeserializer<CacheBuilderSpec> {
        private CacheBuilderSpecDeserializer() {
        }

        @Override
        public CacheBuilderSpec deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            boolean disabled = "off".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text);
            return disabled ? CacheBuilderSpec.disableCaching() : CacheBuilderSpec.parse(text);
        }
    }
}

