/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.jackson;

import java.io.IOException;
import shadow.com.fasterxml.jackson.core.JsonGenerator;
import shadow.com.fasterxml.jackson.core.JsonParser;
import shadow.com.fasterxml.jackson.core.Version;
import shadow.com.fasterxml.jackson.databind.BeanDescription;
import shadow.com.fasterxml.jackson.databind.DeserializationConfig;
import shadow.com.fasterxml.jackson.databind.DeserializationContext;
import shadow.com.fasterxml.jackson.databind.JavaType;
import shadow.com.fasterxml.jackson.databind.JsonDeserializer;
import shadow.com.fasterxml.jackson.databind.JsonMappingException;
import shadow.com.fasterxml.jackson.databind.JsonSerializer;
import shadow.com.fasterxml.jackson.databind.Module;
import shadow.com.fasterxml.jackson.databind.SerializationConfig;
import shadow.com.fasterxml.jackson.databind.SerializerProvider;
import shadow.com.fasterxml.jackson.databind.deser.Deserializers;
import shadow.com.fasterxml.jackson.databind.ser.Serializers;
import shadow.com.github.benmanes.caffeine.cache.CaffeineSpec;

public class CaffeineModule
extends Module {
    @Override
    public String getModuleName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public Version version() {
        return Version.unknownVersion();
    }

    @Override
    public void setupModule(Module.SetupContext context) {
        context.addDeserializers(new CaffeineDeserializers());
        context.addSerializers(new CaffeineSerializers());
    }

    private static class CaffeineSerializers
    extends Serializers.Base {
        private CaffeineSerializers() {
        }

        @Override
        public JsonSerializer<?> findSerializer(SerializationConfig config, JavaType type, BeanDescription beanDesc) {
            if (CaffeineSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CaffeineSpecSerializer();
            }
            return super.findSerializer(config, type, beanDesc);
        }
    }

    private static class CaffeineDeserializers
    extends Deserializers.Base {
        private CaffeineDeserializers() {
        }

        @Override
        public JsonDeserializer<?> findBeanDeserializer(JavaType type, DeserializationConfig config, BeanDescription beanDesc) throws JsonMappingException {
            if (CaffeineSpec.class.isAssignableFrom(type.getRawClass())) {
                return new CaffeineSpecDeserializer();
            }
            return super.findBeanDeserializer(type, config, beanDesc);
        }
    }

    private static class CaffeineSpecSerializer
    extends JsonSerializer<CaffeineSpec> {
        private CaffeineSpecSerializer() {
        }

        @Override
        public void serialize(CaffeineSpec value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            gen.writeString(value.toParsableString());
        }
    }

    private static class CaffeineSpecDeserializer
    extends JsonDeserializer<CaffeineSpec> {
        private CaffeineSpecDeserializer() {
        }

        @Override
        public CaffeineSpec deserialize(JsonParser jp, DeserializationContext ctxt) throws IOException {
            String text = jp.getText();
            boolean disabled = "off".equalsIgnoreCase(text) || "disabled".equalsIgnoreCase(text);
            return CaffeineSpec.parse(disabled ? "initialCapacity=0,maximumSize=0" : text);
        }
    }
}

