/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.configuration;

import shadow.io.dropwizard.configuration.EnvironmentVariableLookup;
import shadow.io.dropwizard.configuration.UndefinedEnvironmentVariableException;
import shadow.org.apache.commons.text.StringSubstitutor;
import shadow.org.apache.commons.text.TextStringBuilder;

public class EnvironmentVariableSubstitutor
extends StringSubstitutor {
    public EnvironmentVariableSubstitutor() {
        this(true, false);
    }

    public EnvironmentVariableSubstitutor(boolean strict) {
        this(strict, false);
    }

    public EnvironmentVariableSubstitutor(boolean strict, boolean substitutionInVariables) {
        super(new EnvironmentVariableLookup());
        this.setEnableUndefinedVariableException(strict);
        this.setEnableSubstitutionInVariables(substitutionInVariables);
    }

    @Override
    protected boolean substitute(TextStringBuilder buf, int offset, int length) {
        try {
            return super.substitute(buf, offset, length);
        }
        catch (IllegalArgumentException e) {
            if (e.getMessage() != null && e.getMessage().contains("Cannot resolve variable")) {
                throw new UndefinedEnvironmentVariableException(e.getMessage());
            }
            throw e;
        }
    }
}

