/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard.client.proxy;

import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.javax.annotation.Nullable;
import shadow.javax.validation.constraints.NotEmpty;
import shadow.javax.validation.constraints.Pattern;

public class AuthConfiguration {
    public static final String BASIC_AUTH_SCHEME = "Basic";
    public static final String NTLM_AUTH_SCHEME = "NTLM";
    public static final String USERNAME_PASSWORD_CREDS = "UsernamePassword";
    public static final String NT_CREDS = "NT";
    @NotEmpty
    private String username = "";
    @NotEmpty
    private String password = "";
    @Pattern(regexp="Basic|NTLM")
    @Nullable
    private @Pattern(regexp="Basic|NTLM") String authScheme;
    @Nullable
    private String realm;
    @Nullable
    private String hostname;
    @Nullable
    private String domain;
    @Pattern(regexp="UsernamePassword|NT", flags={Pattern.Flag.CASE_INSENSITIVE})
    @Nullable
    private @Pattern(regexp="UsernamePassword|NT", flags={Pattern.Flag.CASE_INSENSITIVE}) String credentialType;

    public AuthConfiguration() {
    }

    public AuthConfiguration(String username, String password) {
        this.username = username;
        this.password = password;
    }

    public AuthConfiguration(String username, String password, String authScheme, String realm, String hostname, String domain, String credentialType) {
        this.username = username;
        this.password = password;
        this.authScheme = authScheme;
        this.realm = realm;
        this.hostname = hostname;
        this.domain = domain;
        this.credentialType = credentialType;
    }

    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    public void setUsername(String username) {
        this.username = username;
    }

    @JsonProperty
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public void setPassword(String password) {
        this.password = password;
    }

    @JsonProperty
    @Nullable
    public String getAuthScheme() {
        return this.authScheme;
    }

    @JsonProperty
    public void setAuthScheme(String authScheme) {
        this.authScheme = authScheme;
    }

    @JsonProperty
    @Nullable
    public String getRealm() {
        return this.realm;
    }

    @JsonProperty
    public void setRealm(String realm) {
        this.realm = realm;
    }

    @JsonProperty
    @Nullable
    public String getHostname() {
        return this.hostname;
    }

    @JsonProperty
    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    @JsonProperty
    @Nullable
    public String getDomain() {
        return this.domain;
    }

    @JsonProperty
    public void setDomain(String domain) {
        this.domain = domain;
    }

    @JsonProperty
    @Nullable
    public String getCredentialType() {
        return this.credentialType;
    }

    @JsonProperty
    public void setCredentialType(String credentialType) {
        this.credentialType = credentialType;
    }
}

