/*
 * Decompiled with CFR 0.152.
 */
package shadow.io.dropwizard;

import shadow.com.fasterxml.jackson.annotation.JsonProperty;
import shadow.io.dropwizard.logging.DefaultLoggingFactory;
import shadow.io.dropwizard.logging.LoggingFactory;
import shadow.io.dropwizard.metrics.MetricsFactory;
import shadow.io.dropwizard.server.DefaultServerFactory;
import shadow.io.dropwizard.server.ServerFactory;
import shadow.io.dropwizard.setup.AdminFactory;
import shadow.javax.annotation.Nullable;
import shadow.javax.validation.Valid;
import shadow.javax.validation.constraints.NotNull;

public class Configuration {
    @Valid
    @NotNull
    private ServerFactory server = new DefaultServerFactory();
    @Valid
    @Nullable
    private LoggingFactory logging;
    @Valid
    @NotNull
    private MetricsFactory metrics = new MetricsFactory();
    @Valid
    @NotNull
    private AdminFactory admin = new AdminFactory();

    @JsonProperty(value="server")
    public ServerFactory getServerFactory() {
        return this.server;
    }

    @JsonProperty(value="server")
    public void setServerFactory(ServerFactory factory) {
        this.server = factory;
    }

    @JsonProperty(value="logging")
    public synchronized LoggingFactory getLoggingFactory() {
        if (this.logging == null) {
            this.logging = new DefaultLoggingFactory();
        }
        return this.logging;
    }

    @JsonProperty(value="logging")
    public synchronized void setLoggingFactory(LoggingFactory factory) {
        this.logging = factory;
    }

    @JsonProperty(value="metrics")
    public MetricsFactory getMetricsFactory() {
        return this.metrics;
    }

    @JsonProperty(value="metrics")
    public void setMetricsFactory(MetricsFactory metrics) {
        this.metrics = metrics;
    }

    @JsonProperty(value="admin")
    public AdminFactory getAdminFactory() {
        return this.admin;
    }

    @JsonProperty(value="admin")
    public void setAdminFactory(AdminFactory admin) {
        this.admin = admin;
    }

    public String toString() {
        return "Configuration{server=" + this.server + ", logging=" + this.logging + ", metrics=" + this.metrics + ", admin=" + this.admin + "}";
    }
}

