/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema.walk;

import java.util.List;
import java.util.Map;
import java.util.Set;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonSchemaFactory;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.walk.AbstractWalkListenerRunner;
import shadow.com.networknt.schema.walk.JsonSchemaWalkListener;
import shadow.com.networknt.schema.walk.WalkEvent;

public class DefaultKeywordWalkListenerRunner
extends AbstractWalkListenerRunner {
    private Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap;

    public DefaultKeywordWalkListenerRunner(Map<String, List<JsonSchemaWalkListener>> keywordWalkListenersMap) {
        this.keywordWalkListenersMap = keywordWalkListenersMap;
    }

    @Override
    public boolean runPreWalkListeners(String keyWordPath, JsonNode node, JsonNode rootNode, String at, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, JsonSchemaFactory currentJsonSchemaFactory) {
        String keyword = this.getKeywordName(keyWordPath);
        boolean continueRunningListenersAndWalk = true;
        WalkEvent keywordWalkEvent = this.constructWalkEvent(keyword, node, rootNode, at, schemaPath, schemaNode, parentSchema, currentJsonSchemaFactory);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        continueRunningListenersAndWalk = this.runPreWalkListeners(currentKeywordListeners, keywordWalkEvent);
        if (continueRunningListenersAndWalk) {
            List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("shadow.com.networknt.AllKeywordWalkListener");
            this.runPreWalkListeners(allKeywordListeners, keywordWalkEvent);
        }
        return continueRunningListenersAndWalk;
    }

    @Override
    public void runPostWalkListeners(String keyWordPath, JsonNode node, JsonNode rootNode, String at, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, JsonSchemaFactory currentJsonSchemaFactory, Set<ValidationMessage> validationMessages) {
        String keyword = this.getKeywordName(keyWordPath);
        WalkEvent keywordWalkEvent = this.constructWalkEvent(keyword, node, rootNode, at, schemaPath, schemaNode, parentSchema, currentJsonSchemaFactory);
        List<JsonSchemaWalkListener> currentKeywordListeners = this.keywordWalkListenersMap.get(keyword);
        this.runPostWalkListeners(currentKeywordListeners, keywordWalkEvent, validationMessages);
        List<JsonSchemaWalkListener> allKeywordListeners = this.keywordWalkListenersMap.get("shadow.com.networknt.AllKeywordWalkListener");
        this.runPostWalkListeners(allKeywordListeners, keywordWalkEvent, validationMessages);
    }
}

