/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema.walk;

import java.util.List;
import java.util.Set;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonSchemaFactory;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.walk.JsonSchemaWalkListener;
import shadow.com.networknt.schema.walk.WalkEvent;
import shadow.com.networknt.schema.walk.WalkFlow;
import shadow.com.networknt.schema.walk.WalkListenerRunner;

public abstract class AbstractWalkListenerRunner
implements WalkListenerRunner {
    protected String getKeywordName(String keyWordPath) {
        return keyWordPath.substring(keyWordPath.lastIndexOf(47) + 1);
    }

    protected WalkEvent constructWalkEvent(String keyWordName, JsonNode node, JsonNode rootNode, String at, String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, JsonSchemaFactory currentJsonSchemaFactory) {
        return WalkEvent.builder().at(at).keyWordName(keyWordName).node(node).parentSchema(parentSchema).rootNode(rootNode).schemaNode(schemaNode).schemaPath(schemaPath).currentJsonSchemaFactory(currentJsonSchemaFactory).build();
    }

    protected boolean runPreWalkListeners(List<JsonSchemaWalkListener> walkListeners, WalkEvent walkEvent) {
        boolean continueToWalkMethod = true;
        if (walkListeners != null) {
            for (JsonSchemaWalkListener walkListener : walkListeners) {
                WalkFlow walkFlow = walkListener.onWalkStart(walkEvent);
                if (!WalkFlow.SKIP.equals((Object)walkFlow) && !WalkFlow.ABORT.equals((Object)walkFlow)) continue;
                continueToWalkMethod = false;
                if (!WalkFlow.ABORT.equals((Object)walkFlow)) continue;
                break;
            }
        }
        return continueToWalkMethod;
    }

    protected void runPostWalkListeners(List<JsonSchemaWalkListener> walkListeners, WalkEvent walkEvent, Set<ValidationMessage> validationMessages) {
        if (walkListeners != null) {
            for (JsonSchemaWalkListener walkListener : walkListeners) {
                walkListener.onWalkEnd(walkEvent, validationMessages);
            }
        }
    }
}

