/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema.uri;

import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import shadow.com.networknt.schema.uri.URIFactory;

public final class URLFactory
implements URIFactory {
    public static final Set<String> SUPPORTED_SCHEMES = Collections.unmodifiableSet(new HashSet<String>(Arrays.asList("http", "https", "ftp", "file", "jar")));

    @Override
    public URI create(String uri) {
        try {
            return new URL(uri).toURI();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to create URI.", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create URI.", e);
        }
    }

    @Override
    public URI create(URI baseURI, String segment) {
        try {
            return new URL(baseURI.toURL(), segment).toURI();
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException("Unable to create URI.", e);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Unable to create URI.", e);
        }
    }
}

