/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema.uri;

import java.net.URI;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import shadow.com.networknt.schema.uri.URIFactory;

public class URISchemeFactory
implements URIFactory {
    private static final Pattern URI_SCHEME_PATTERN = Pattern.compile("^([a-z][a-z0-9+\\.\\-\\\\]*):");
    private final Map<String, URIFactory> uriFactories;

    public URISchemeFactory(Map<String, URIFactory> uriFactories) {
        if (uriFactories == null) {
            throw new IllegalArgumentException("URIFactory map must not be null");
        }
        this.uriFactories = uriFactories;
    }

    public Map<String, URIFactory> getURIFactories() {
        return this.uriFactories;
    }

    private String getScheme(String uri) {
        Matcher matcher = URI_SCHEME_PATTERN.matcher(uri);
        if (matcher.find()) {
            return matcher.group(1);
        }
        return null;
    }

    private URIFactory getFactory(String scheme) {
        URIFactory uriFactory = this.uriFactories.get(scheme);
        if (uriFactory == null) {
            throw new IllegalArgumentException(String.format("Unsupported URI scheme encountered: %s", scheme));
        }
        return uriFactory;
    }

    @Override
    public URI create(String uri) {
        String scheme = this.getScheme(uri);
        if (scheme == null) {
            throw new IllegalArgumentException(String.format("Couldn't find URI scheme: %s", uri));
        }
        URIFactory uriFactory = this.getFactory(scheme);
        return uriFactory.create(uri);
    }

    @Override
    public URI create(URI baseURI, String segment) {
        if (baseURI == null) {
            return this.create(segment);
        }
        String scheme = this.getScheme(segment);
        if (scheme == null) {
            scheme = baseURI.getScheme();
            URIFactory uriFactory = this.getFactory(scheme);
            return uriFactory.create(baseURI, segment);
        }
        URIFactory uriFactory = this.getFactory(scheme);
        return uriFactory.create(segment);
    }
}

