/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonSchemaException;
import shadow.com.networknt.schema.JsonType;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.TypeFactory;
import shadow.com.networknt.schema.TypeValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;

public class UnionTypeValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(UnionTypeValidator.class);
    private List<JsonValidator> schemas = new ArrayList<JsonValidator>();
    private String error;

    public UnionTypeValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.UNION_TYPE, validationContext);
        StringBuilder errorBuilder = new StringBuilder();
        String sep = "";
        errorBuilder.append('[');
        if (!schemaNode.isArray()) {
            throw new JsonSchemaException("Expected array for type property on Union Type Definition.");
        }
        int i = 0;
        for (JsonNode n : schemaNode) {
            JsonType t = TypeFactory.getSchemaNodeType(n);
            errorBuilder.append(sep).append((Object)t);
            sep = ", ";
            if (n.isObject()) {
                this.schemas.add(new JsonSchema(validationContext, ValidatorTypeCode.TYPE.getValue(), parentSchema.getCurrentUri(), n, parentSchema));
            } else {
                this.schemas.add(new TypeValidator(schemaPath + "/" + i, n, parentSchema, validationContext));
            }
            ++i;
        }
        errorBuilder.append(']');
        this.error = errorBuilder.toString();
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        JsonType nodeType = TypeFactory.getValueNodeType(node, this.config);
        boolean valid = false;
        for (JsonValidator schema : this.schemas) {
            Set<ValidationMessage> errors = schema.validate(node, rootNode, at);
            if (errors != null && !errors.isEmpty()) continue;
            valid = true;
            break;
        }
        if (!valid) {
            return Collections.singleton(this.buildValidationMessage(at, nodeType.toString(), this.error));
        }
        return Collections.emptySet();
    }
}

