/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.JsonMetaSchema;
import shadow.com.networknt.schema.JsonSchemaException;
import shadow.com.networknt.schema.JsonSchemaFactory;
import shadow.com.networknt.schema.SpecVersion;

public class SpecVersionDetector {
    private static final String SCHEMA_TAG = "$schema";

    public static SpecVersion.VersionFlag detect(JsonNode jsonNode) {
        if (!jsonNode.has(SCHEMA_TAG)) {
            throw new JsonSchemaException("Schema tag not present");
        }
        String schemaUri = JsonSchemaFactory.normalizeMetaSchemaUri(jsonNode.get(SCHEMA_TAG).asText());
        if (schemaUri.equals(JsonMetaSchema.getV4().getUri())) {
            return SpecVersion.VersionFlag.V4;
        }
        if (schemaUri.equals(JsonMetaSchema.getV6().getUri())) {
            return SpecVersion.VersionFlag.V6;
        }
        if (schemaUri.equals(JsonMetaSchema.getV7().getUri())) {
            return SpecVersion.VersionFlag.V7;
        }
        if (schemaUri.equals(JsonMetaSchema.getV201909().getUri())) {
            return SpecVersion.VersionFlag.V201909;
        }
        throw new JsonSchemaException("Unrecognizable schema");
    }
}

