/*
 * Decompiled with CFR 0.152.
 */
package shadow.com.networknt.schema;

import java.net.URI;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import shadow.com.fasterxml.jackson.databind.JsonNode;
import shadow.com.networknt.schema.BaseJsonValidator;
import shadow.com.networknt.schema.CustomErrorMessageType;
import shadow.com.networknt.schema.JsonSchema;
import shadow.com.networknt.schema.JsonSchemaException;
import shadow.com.networknt.schema.JsonSchemaRef;
import shadow.com.networknt.schema.JsonValidator;
import shadow.com.networknt.schema.ValidationContext;
import shadow.com.networknt.schema.ValidationMessage;
import shadow.com.networknt.schema.ValidatorTypeCode;
import shadow.com.networknt.schema.uri.URIFactory;
import shadow.com.networknt.schema.urn.URNFactory;

public class RefValidator
extends BaseJsonValidator
implements JsonValidator {
    private static final Logger logger = LoggerFactory.getLogger(RefValidator.class);
    protected JsonSchemaRef schema;
    private JsonSchema parentSchema;
    private ValidationContext validationContext;
    private static final String REF_CURRENT = "#";

    public RefValidator(String schemaPath, JsonNode schemaNode, JsonSchema parentSchema, ValidationContext validationContext) {
        super(schemaPath, schemaNode, parentSchema, ValidatorTypeCode.REF, validationContext);
        String refValue = schemaNode.asText();
        this.schema = RefValidator.getRefSchema(parentSchema, validationContext, refValue);
        this.parentSchema = parentSchema;
        this.validationContext = validationContext;
        if (this.schema == null) {
            throw new JsonSchemaException(ValidationMessage.of(ValidatorTypeCode.REF.getValue(), CustomErrorMessageType.of("internal.unresolvedRef", new MessageFormat("{0}: Reference {1} cannot be resolved")), schemaPath, refValue));
        }
    }

    static JsonSchemaRef getRefSchema(JsonSchema parentSchema, ValidationContext validationContext, String refValue) {
        String refValueOriginal = refValue;
        if (!refValue.startsWith(REF_CURRENT)) {
            int index = refValue.indexOf(REF_CURRENT);
            String refUri = index > 0 ? refValue.substring(0, index) : refValue;
            URI schemaUri = RefValidator.determineSchemaUri(validationContext.getURIFactory(), parentSchema, refUri);
            if (schemaUri == null) {
                if (validationContext.getURNFactory() == null) {
                    return null;
                }
                schemaUri = RefValidator.determineSchemaUrn(validationContext.getURNFactory(), refUri);
                if (schemaUri == null) {
                    return null;
                }
            }
            parentSchema = validationContext.getJsonSchemaFactory().getSchema(schemaUri, validationContext.getConfig());
            if (index < 0) {
                return new JsonSchemaRef(parentSchema.findAncestor());
            }
            refValue = refValue.substring(index);
        }
        if (refValue.equals(REF_CURRENT)) {
            return new JsonSchemaRef(parentSchema.findAncestor());
        }
        JsonNode node = parentSchema.getRefSchemaNode(refValue);
        if (node != null) {
            JsonSchemaRef ref = validationContext.getReferenceParsingInProgress(refValueOriginal);
            if (ref == null) {
                JsonSchema schema = new JsonSchema(validationContext, refValue, parentSchema.getCurrentUri(), node, parentSchema);
                ref = new JsonSchemaRef(schema);
                validationContext.setReferenceParsingInProgress(refValueOriginal, ref);
            }
            return ref;
        }
        return null;
    }

    private static URI determineSchemaUri(URIFactory uriFactory, JsonSchema parentSchema, String refUri) {
        URI schemaUri;
        URI currentUri = parentSchema.getCurrentUri();
        try {
            schemaUri = currentUri == null ? uriFactory.create(refUri) : uriFactory.create(currentUri, refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUri = null;
        }
        return schemaUri;
    }

    private static URI determineSchemaUrn(URNFactory urnFactory, String refUri) {
        URI schemaUrn;
        try {
            schemaUrn = urnFactory.create(refUri);
        }
        catch (IllegalArgumentException e) {
            schemaUrn = null;
        }
        return schemaUrn;
    }

    @Override
    public Set<ValidationMessage> validate(JsonNode node, JsonNode rootNode, String at) {
        this.debug(logger, node, rootNode, at);
        if (this.schema != null) {
            return this.schema.validate(node, rootNode, at);
        }
        return Collections.emptySet();
    }

    @Override
    public Set<ValidationMessage> walk(JsonNode node, JsonNode rootNode, String at, boolean shouldValidateSchema) {
        if (this.schema != null) {
            return this.schema.walk(node, rootNode, at, shouldValidateSchema);
        }
        return Collections.emptySet();
    }

    public JsonSchemaRef getSchemaRef() {
        return this.schema;
    }
}

